import { ReactNode } from 'react';
import Banners from '@components/banners';
import MainFooter from './footer';
import MainHeader from './header';

interface Layout {
  children: ReactNode;
}

export default function MainLayout({ children }: Layout) {
  return (
    <>
      <MainHeader />
      <div className="w-full min-h-[70vh]">{children}</div>
      <div className="sm:px-10 px-5 py-5 w-full">
        <Banners position="footer" layout="horizontal" />
      </div>
      <MainFooter />
    </>
  );
}
