import Link from 'next/link';
import classNames from 'classnames';
import { usePathname } from 'next/navigation';
import { XMarkIcon } from '@heroicons/react/24/solid';
import s from './navbar.module.scss';

interface Props {
  className?: string;
  onClose?: () => void;
}

const menuItems = [
  {
    href: '/videos/trending',
    children: 'trending',
    key: 'videos'
  },
  {
    href: '/categories',
    children: 'categories',
    key: 'categories'
  },
  {
    href: '/pornstars',
    children: 'pornstars',
    key: 'pornstars'
  }
];

export function Navbar({ className, onClose }: Props) {
  const pathname = usePathname();

  return (
    <div
      className={classNames(s.navbar, className, 'relative')}
      id="navbar-default"
    >
      <h3 className="md:hidden text-primary p-5 font-semibold text-lg uppercase">
        Menu
      </h3>
      <XMarkIcon
        width={24}
        height={24}
        className="md:hidden absolute right-2 top-4"
        onClick={onClose}
      />
      <div className="bg-grey w-full h-[1px]" />
      <div className={s['navbar-menu']}>
        <ul className="font-bold text-sm flex max-md:block items-center flex-col md:flex-row md:space-x-4">
          {menuItems.map((menuItem) => (
            <li key={menuItem.key}>
              <Link
                href={menuItem.href}
                className={classNames(
                  'block py-2 px-3 text-gray-900 dark:text-white rounded hover:bg-gray-100 md:hover:bg-transparent md:border-0 hover:text-primary hover:dark:text-primary md:p-0 dark:hover:bg-gray-700 md:dark:hover:bg-transparent uppercase text-nowrap whitespace-nowrap',
                  { 'text-primary': pathname.includes(menuItem.href) }
                )}
              >
                {menuItem.children}
              </Link>
            </li>
          ))}
        </ul>
      </div>
    </div>
  );
}
