'use client';

import { Navbar } from '@components/layout/header/navbar';
import {
  Bars3Icon,
  XMarkIcon,
  MagnifyingGlassIcon
} from '@heroicons/react/24/solid';
import classNames from 'classnames';
import { useCallback, useRef, useState } from 'react';
import { InputSearch } from '@components/ui/form';
import { useOnClickOutside } from 'usehooks-ts';
import SiteLogo from '../site-logo';
import s from './navbar.module.scss';

export default function MainHeader() {
  const [showMenu, setShowMenu] = useState(false);
  const [showSearch, setShowSearch] = useState(false);

  const ref = useRef<HTMLDivElement>(null);
  const handleClickOutside = useCallback(() => {
    if (showSearch) setShowSearch(false);
  }, [showSearch]);

  useOnClickOutside(ref, handleClickOutside);

  const handleShowMenu = () => {
    setShowMenu(!showMenu);
  };
  const handleCloseMenu = () => {
    setShowMenu(!showMenu);
  };

  const handleSearch = useCallback(() => {
    setShowSearch(!showSearch);
  }, [showSearch]);

  return (
    <>
      <header className="flex justify-between fixed items-center h-22 sm:px-10 lg:px-10 px-2.5 max-md:py-3 py-5 w-full top-0 z-50 backdrop-blur-md bg-opacity-80 dark:bg-opacity-80 max-h-[72px] h-[72px]">
        <div className="flex items-center gap-3">
          <span tabIndex={0} onKeyDown={() => {}} role="button" className="md:hidden" onClick={handleShowMenu}>
            {!showMenu ? (
              <Bars3Icon width={30} height={30} />
            ) : (
              <XMarkIcon width={30} height={30} />
            )}
          </span>
          <a aria-label="url" href="/">
            <SiteLogo />
          </a>
        </div>
        <div className="inline-flex">
          <Navbar
            className={showMenu ? 'show' : ''}
            onClose={handleCloseMenu}
          />
          <ul className="list-none whitespace-nowrap flex items-center">
            <li className="px-1 relative">
              <div aria-hidden onClick={handleSearch}>
                {showSearch ? (
                  <XMarkIcon
                    className="text-black dark:text-white"
                    width={26}
                    height={26}
                  />
                ) : (
                  <MagnifyingGlassIcon
                    className="text-black dark:text-white"
                    width={26}
                    height={26}
                  />
                )}
              </div>
              <div
                className="absolute end-1 top-9 w-[75vw] sm:w-[50vw]"
                hidden={!showSearch}
                ref={ref}
              >
                <InputSearch defaultValue="" pathname="/videos/search" onChange={handleSearch} />
              </div>
            </li>
          </ul>
        </div>
      </header>
      <div
        aria-label="menu"
        tabIndex={0}
        role="button"
        onKeyDown={() => {}}
        onClick={handleCloseMenu}
        className={classNames(
          s['bg-menu'],
          `${
            showMenu ? 'show' : ''
          } fixed w-full left-0 bg-black hidden max-md:block dark:bg-opacity-40 bg-opacity-10`
        )}
      />
    </>
  );
}
