import { postService } from '@services/post.service';
import classNames from 'classnames';
import Link from 'next/link';
import { IPost } from 'src/interfaces';

export default async function FooterMenus() {
  const { data } = await postService.getMenus();

  return (
    <div className={classNames('sm:px-10 px-2.5 py-10 flex flex-wrap justify-center', { '!justify-start': data && data.length >= 2 })}>
      {data && data.map((menu: any) => (
        <div key={menu._id} className="sm:w-1/4 w-1/2 text-center">
          <p className="dark:text-white text-white font-bold mb-5">{menu.category?.title}</p>
          <ul className="list-none text-sm">
            {menu.posts.map((post: IPost) => (
              <li key={post._id} className=" mb-1">
                <Link href={`/posts/${post.slug || post._id}`}>
                  {post.title}
                </Link>
              </li>
            ))}
          </ul>
        </div>
      ))}
      <div className="sm:w-1/4 w-1/2 text-center">
        <p className="dark:text-white text-white font-bold mb-5">Discover</p>
        <ul className="list-none text-sm">
          <li className="mb-1">
            <Link href="/pornstars">Pornstars</Link>
          </li>
          <li className="mb-1">
            <Link href="/categories">Categories</Link>
          </li>
        </ul>
      </div>
    </div>
  );
}
