import { categoryService } from '@services/category.services';
import CategoriesGrid from './categories-grid';

export default async function TopCategories() {
  const { error, data } = await categoryService.search({
    limit: 9,
    sortBy: 'trending',
    group: 'video'
  });
  if (error) return null;
  if (!data!.data.length) return null;
  const showMoreCategories = {
    _id: 'show-more',
    slug: 'show-more'
  };

  return (
    <CategoriesGrid categories={[...data!.data, showMoreCategories]} showMorePath="/categories" />
  );
}
