'use client';

import { formatNumber } from '@lib/utils';
import Image from 'next/image';
import Link from 'next/link';
import { ICategory } from 'src/interfaces';
import { useMainThemeLayout } from 'src/providers/main-layout.provider';

interface Props {
  dataSource: ICategory;
}

export function CategoryGridItem({ dataSource }: Props) {
  const { publicSettings } = useMainThemeLayout();

  return (
    <Link href={`/categories/${dataSource.slug || dataSource._id}`}>
      <div className="rounded-lg cursor-pointer border-2">
        <div className="relative pt-[125%] w-full rounded-t-md overflow-hidden">
          <Image style={{ objectFit: 'cover' }} src={dataSource.posterUrl || publicSettings.defaultThumbnailImage || '/images/placeholder.png'} alt="" fill priority />
        </div>
        <div className="p-4 text-sm text-center text-black dark:text-white">
          <h3 className="text-ellipsis overflow-hidden whitespace-nowrap text-base capitalize">{dataSource.title}</h3>
          <p className="text-sm">
            (
            {formatNumber(dataSource.stats.videos)}
            {' '}
            Videos)
          </p>
        </div>
      </div>
    </Link>
  );
}
