import { ICategory } from 'src/interfaces';
import classNames from 'classnames';
import Link from 'next/link';
import { ArrowRightIcon } from '@heroicons/react/24/outline';
import { CategoryGridItem } from './grid-item';

interface Props {
  categories: (ICategory | any)[];
  span?: {
    xs?: number;
    md?: number;
    sm?: number;
    lg?: number;
    xl?: number;
  };
  className?: string;
  showMorePath?: string;
}

export default function CategoriesGrid({
  categories,
  className = '',
  span = {
    xs: 2, sm: 3, md: 4, lg: 5, xl: 6
  },
  showMorePath = '/default-path'
}: Props) {
  if (!categories) return null;
  if (!categories.length) return null;

  return (
    <div
      className={classNames(
        `grid grid-cols-${span.xs} gap-3 md:grid-cols-${span.md} lg:grid-cols-${span.lg} xl:grid-cols-5 gird-responsive`,
        className
      )}
    >
      {categories.map((category) => {
        if (category._id === 'show-more') {
          return (
            <Link href={showMorePath} key={category._id} passHref>
              <div className="flex items-center justify-center border-2 rounded-lg cursor-pointer text-lg font-bold text-orange-500 h-full w-full xl:grid-cols-5">
                Show more
                {' '}
                <ArrowRightIcon className="w-8 h-8 ms-2 stroke-2" />
              </div>
            </Link>
          );
        }
        return <CategoryGridItem dataSource={category} key={category._id} />;
      })}
    </div>
  );
}
