import { adsService } from '@services/ads.service';
import AdsSlider from './banner-slider';

interface Props {
  position: string;
  type?: string;
  containerClassname?: string;
  // imageClassname?: string;
  limit?: number;
}

export default async function SingleAds({
  position,
  type = '',
  containerClassname = '',
  // imageClassname = '',
  limit = 3
}: Props) {
  // Fetch ads data
  const { error, data } = await adsService.search({
    position,
    status: 'active',
    type,
    limit
  });

  if (error || !data!.data.length) return null;

  return (
    <div className={containerClassname}>
      <AdsSlider
        banners={data!.data}
        settings={{
          autoplay: true,
          autoplaySpeed: 2000,
          dots: false
        }}
        className="w-full"
        imageProps={{
          unoptimized: true,
          priority: true
        }}
      />
    </div>
  );
}
