import { adsService } from '@services/ads.service';
import BannerGrid from './banner-grid';

interface Props {
  layout?: 'vertical' | 'horizontal';
  position: 'video' | 'footer'
}

export default async function Banners({ layout = 'horizontal', position }: Props) {
  const { error, data } = await adsService.search({
    position,
    status: 'active'
  });
  if (error) return null;
  if (!data!.data.length) return null;

  const images = data!.data.filter((banner) => banner.type === 'image');

  return (
    <div className={images.length ? 'border-2 p-1 rounded-md' : ''}>
      <BannerGrid
        banners={data!.data}
        layout={layout}
        containerClassname="text-center overflow-hidden"
      />
    </div>
  );
}
