import { adsService } from '@services/ads.service';
import AdsSlider from './banner-slider';

export default async function HomeAds() {
  const { error, data } = await adsService.search({ position: 'home', status: 'active' });
  if (error) return null;
  if (!data!.data.length) return null;

  return <AdsSlider imageProps={{ priority: true }} banners={data!.data} />;
}
