'use client';

import classNames from 'classnames';
import Image from 'next/image';
import Slider from 'react-slick';
import { Ads } from 'src/interfaces';

interface Props {
  banners: Ads[];
  settings?: any;
  className?: string;
  imageProps?: {
    priority?: boolean | undefined;
    unoptimized?: boolean;
  };
}

export default function AdsSlider({
  banners,
  settings = {},
  className = '',
  imageProps = {}
}: Props) {
  if (!banners.length) return null;

  return (
    <div className="w-full">
      <Slider
        {...{
          dots: true,
          infinite: true,
          speed: 500,
          autoplay: true,
          autoplaySpeed: 5000,
          slidesToShow: 1,
          slidesToScroll: 1,
          arrows: false,
          dotsClass: 'slick-dots bottom-6',
          ...settings
        }}
      >
        {banners.map((banner) => {
          if (banner.type === 'script_code' && banner.scriptCode) {
            // eslint-disable-next-line react/no-danger
            return <div key={banner._id} dangerouslySetInnerHTML={{ __html: banner.scriptCode }} />;
          }

          return (
            <a href={banner.adUrl} target="_blank" key={banner._id} rel="noreferrer">
              <div
                className={classNames(
                  'w-full relative focus-visible:outline-none md:pt-[20%] pt-[33%]',
                  className
                )}
              >
                <Image
                  src={banner.fileUrl || '/images/ads2.jpg'}
                  alt={banner.name}
                  fill
                  className="object-fill md:object-cover"
                  {...imageProps}
                  unoptimized
                />
              </div>
            </a>
          );
        })}
      </Slider>
    </div>
  );
}
