'use client';

import Image from 'next/image';
import { Fragment } from 'react';
import { Ads } from 'src/interfaces';
import ScriptBanner from './script-banner';

interface Props {
  banners: Ads[];
  layout?: 'vertical' | 'horizontal';
  containerClassname?: string;
}

export default function BannerGrid({
  banners,
  layout = 'horizontal',
  containerClassname = ''
}: Props) {
  return (
    <div className={containerClassname}>
      {banners.map((banner) => (
        <Fragment key={banner._id}>
          {banner.type === 'script_code' ? (
            <ScriptBanner banner={banner} />
          ) : (
            // eslint-disable-next-line jsx-a11y/control-has-associated-label
            <a href={banner.adUrl} key={banner._id} target="_blank" rel="noreferrer">
              <Image
                src={banner.fileUrl || '/images/ads.png'}
                alt=""
                width={300}
                height={150}
                priority
                className={
                  layout === 'horizontal'
                    ? 'inline-block py-6 px-1'
                    : 'min-h-[150px] w-full py-1'
                }
              />
            </a>
          )}
        </Fragment>
      ))}
    </div>
  );
}
