/* eslint-disable react/no-danger */
import parse from 'html-react-parser';
import type { Metadata } from 'next';
import { ToastContainer } from 'react-toastify';
import { settingService } from 'src/services';
import { GoogleAnalytics, GoogleTagManager } from '@next/third-parties/google';
import { defaultSettings } from '@lib/utils';
import NextTopLoader from 'nextjs-toploader';

import { testJSON } from '@lib/string';
import { ReactNode } from 'react';

import './globals.css';
import './responsive.css';
import 'react-toastify/dist/ReactToastify.css';

export async function generateMetadata(): Promise<Metadata> {
  const {
    data: settings = {
      siteName: 'xStreamer',
      logoUrl: '',
      favicon: '',
      homeTitle: 'Home',
      homeMetaKeywords: '',
      homMetaDescription: '',
      headerScript: '',
      afterBodyScript: '',
      gaCode: '',
      htmlMetaTags: ''
    }
  } = await settingService.all();

  return {
    ...(process.env.BASE_URL && { metadataBase: new URL(process.env.BASE_URL) }),
    title: {
      default: settings.siteName,
      template: `%s | ${settings.siteName}`
    },
    description: settings.homMetaDescription || 'xStreamer',
    keywords: settings.homeMetaKeywords,
    verification: {
      other: testJSON(settings.htmlMetaTags) ? JSON.parse(settings.htmlMetaTags) : {}
    }
  };
}

export const revalidate = 3600; // revalidate at most every hour

export default async function RootLayout({
  children
}: {
  children: ReactNode;
}) {
  const {
    data: settings = defaultSettings
  } = await settingService.all();

  return (
    <html lang="en" data-theme="dark">
      <head>
        {settings.favicon && (
          <link rel="icon" type="image/x-icon" href={settings.favicon} />
        )}
        {settings.headerScript && parse(settings.headerScript)}
      </head>
      <body suppressHydrationWarning>
        <NextTopLoader height={2} color="#f97316" />
        {children}
        <ToastContainer />
        {settings.afterBodyScript && parse(settings.afterBodyScript)}
        {settings.gaCode && (
          <GoogleAnalytics gaId={settings.gaCode} />
        )}
        {settings.gtmId && (
          <GoogleTagManager gtmId={settings.gtmId} />
        )}
      </body>
    </html>
  );
}
