// Import necessary modules
import { NextResponse } from 'next/server';

// Define the POST handler for the file upload
export const POST = async (req: any) => {
  try {
    // Parse the incoming form data
    const formData = await req.formData();

    // Get the file from the form data
    const file = formData.get('file');

    // Check if a file is received
    if (!file) {
      // If no file is received, return a JSON response with an error and a 400 status code
      return NextResponse.json({ error: 'No files received.' }, { status: 400 });
    }

    // Return a JSON response with a success message and a 201 status code
    return NextResponse.json({ success: true, status: 201 });
  } catch (error) {
    // If an error occurs during file writing, log the error and return a JSON response with a failure message and a 500 status code
    return NextResponse.json({ Message: 'Failed', status: 500 });
  }
};
