/** @type {import('next').NextConfig} */
const nextConfig = {
  distDir: 'dist/.next',
  poweredByHeader: false,
  eslint: {
    // Warning: This allows production builds to successfully complete even if
    // your project has ESLint errors.
    ignoreDuringBuilds: true
  },
  reactStrictMode: false,
  experimental: {
    serverActions: {
      bodySizeLimit: '2mb'
    },
    scrollRestoration: true
  },
  images: {
    unoptimized: true,
    remotePatterns: [
      {
        protocol: 'https',
        hostname: 'tn.thegay.com',
        port: '',
        pathname: '/contents/**'
      },
      {
        protocol: 'https',
        hostname: process.env.EXTERNAL_IMAGE_FILE_HOSTNAME,
        port: '',
        pathname: '/**'
      },
      {
        protocol: 'https',
        hostname: 'tn.hdzog.com',
        port: '',
        pathname: '/contents/**'
      },
      {
        hostname: 'localhost'
      },
      {
        hostname: '*.videohdzog.com'
      },
      {
        hostname: '*.voyeurhit.com'
      },
      {
        hostname: '*.upornia.com'
      },
      {
        hostname: '*.vjav.com'
      },
      {
        hostname: '*.hclips.com'
      },
      {
        hostname: 'tn.*.com'
      }
    ]
  },
  async rewrites() {
    return [
      {
        source: '/:lang/videos/trending',
        destination: '/:lang/videos?sortBy=trending'
      },
      {
        source: '/:lang/videos/new',
        destination: '/:lang/videos?sortBy=new'
      },
      {
        source: '/:lang/videos/rating',
        destination: '/:lang/videos?sortBy=rating'
      },
      {
        source: '/:lang/account/my-video-upload',
        destination: '/:lang/account/my-upload'
      },
      {
        source: '/:lang/account/my-video-upload/upload',
        destination: '/:lang/account/my-upload/upload'
      }

    ];
  },
  async headers() {
    return [
      {
        source: '/api/revalidate',
        headers: [
          { key: 'Access-Control-Allow-Credentials', value: 'true' },
          { key: 'Access-Control-Allow-Origin', value: '*' },
          { key: 'Access-Control-Allow-Methods', value: 'GET' },
          { key: 'Access-Control-Allow-Headers', value: 'X-CSRF-Token, X-Requested-With, Accept, Accept-Version, Content-Length, Content-MD5, Content-Type, Date, X-Api-Version, Authorization' }
        ]
      }
    ];
  },
  env: {
    VIDEO_FILE_ACCEPT: process.env.VIDEO_FILE_ACCEPT || 'video/*,.mkv,.flv'
  }
};

module.exports = nextConfig;
