import { IVideoUpload, Res } from 'src/interfaces';
import { getResponseError } from '../lib';
import { APIRequest } from './api-request';

export class VideoService extends APIRequest {
  public create(data: IVideoUpload): Promise<Res> {
    return this.post('/admin/videos', data)
      .catch(async (error) => {
        const e = await Promise.resolve(error);
        return {
          error: getResponseError(e)
        };
      });
  }

  public search(query = {}, headers = {}): Promise<Res> {
    return this.get(this.buildUrl('/admin/videos', query), headers, { next: { tags: ['search', 'video'] } })
      .catch(async (error) => {
        const e = await Promise.resolve(error);
        return {
          error: getResponseError(e)
        };
      });
  }

  public findOne(id: string, headers = {}): Promise<Res> {
    return this.get('/admin/videos/' + id, headers, { next: { tags: ['search', 'video'] } })
      .catch(async (error) => {
        const e = await Promise.resolve(error);
        return {
          error: getResponseError(e)
        };
      });
  }

  public delete(id: string) {
    return this.del('/admin/videos/' + id);
  }

  public signUploadFileUrl() {
    return this.signUploadUrl({
      url: '/admin/videos/main/sign-upload-url'
    });
  }

  public uploadVideoFile(
    uploadUrl: string,
    file: any,
    onProgress?: Function
  ) {
    return this.upload({
      url: uploadUrl, file, fieldName: 'file', onProgress
    });
  }

  getFileUploadedInfo(fileId: string) {
    return this.get(`/admin/videos/files/${fileId}/info`, { next: { tags: ['search', 'video', 'file'] } });
  }

  public update(id: string, data: Record<string, any>) {
    return this.put('/admin/videos/' + id, data);
  }
}

export const videoService = new VideoService();