import { APIRequest } from './api-request';
import { message } from 'antd';

export class UtilsService extends APIRequest {
 public async clearCache() {
  try {
    await Promise.all([
      this.get(`${process.env.BACK_OFFICE_ENDPOINT}/api/revalidate?tag=search`),
      this.get(`${process.env.FRONT_OFFICE_ENDPOINT}/api/revalidate?tag=search`)
    ])
    message.success('Cached data is cleared')
  } catch {
    message.error('Request Fail')
  }
 }
}

export const utilsService = new UtilsService();