import { getResponseError } from '@lib/utils';
import { APIRequest } from './api-request';
import { ITag, Res } from 'src/interfaces';

export class TagService extends APIRequest {
  public search(query = {}, headers = {}): Promise<Res<ITag[]>> {
    return this.get(this.buildUrl('/admin/tags', query), headers)
      .catch(async (error) => {
        const e = await Promise.resolve(error);
        return {
          error: getResponseError(e)
        };
      });
  }

  public findOne(id: string, headers = {}): Promise<Res<ITag>> {
    return this.get('/admin/tags/' + id, headers)
      .catch(async (error) => {
        const e = await Promise.resolve(error);
        return {
          error: getResponseError(e)
        };
      });
  }

  public delete(id: string) {
    return this.del('/admin/tags/' + id);
  }

  public update(id: string, data: Record<string, any>) {
    return this.put('/admin/tags/' + id, data);
  }
}

export const tagService = new TagService();