import { getResponseError } from '@lib/utils';
import { APIRequest } from './api-request';
import { Res } from 'src/interfaces';

export class StatsService extends APIRequest {
  public search(query = {}, headers = {}): Promise<Res<any>> {
    return this.get(this.buildUrl('/admin/stats', query), headers, { next: { tags: ['search', 'dashboard'] } })
      .catch(async (error) => {
        const e = await Promise.resolve(error);
        return {
          error: getResponseError(e)
        };
      });
  }
}

export const statsService = new StatsService();