import { IProfile, Res } from 'src/interfaces';
import { APIRequest } from './api-request';
import { getResponseError } from '@lib/utils';

export class ProfileService extends APIRequest {
  search(query?: { [key: string]: any }, headers = {}): Promise<Res<IProfile[]>> {
    return this.get(this.buildUrl('/admin/profiles/search', query), headers, { next: { tags: ['search', 'user'] } })
      .catch(async (error) => {
        const e = await Promise.resolve(error);
        return {
          error: getResponseError(e)
        };
      });
  }

  getMe(token?: string) {
    const headers = token ? {
      Authorization: token
    } : undefined;
    return this.get('/profiles/me', headers);
  }

  findById(id: string, options?: any) {
    return this.get(this.buildUrl(`/admin/profiles/${id}`), {}, options).then((res) => ({ data: res, error: null })).catch((error) => ({ data: null, error }));
  }

  create(data: any) {
    return this.post('/admin/profiles', data);
  }

  update(id: string, data: any) {
    return this.put(`/admin/profiles/${id}`, data);
  }

  getAvatarUploadUrl() {
    return this.post('/admin/profiles/avatar/upload-url');
  }

  uploadAvatar(uploadUrl: string, file: File, onProgress = () => { }) {
    return this.upload({
      type: 'avatar',
      file,
      url: uploadUrl,
      onProgress
    });
  }

  // docs
  getProfileDocs(profileId: any) {
    return this.post('/admin/profiles/documents', profileId);
  }
}

export const profileService = new ProfileService();
