import { getResponseError } from '@lib/utils';
import { APIRequest } from './api-request';
import { IPost, Res } from 'src/interfaces';

export class PostService extends APIRequest {
  public search(query = {}, headers = {}): Promise<Res<IPost[]>> {
    return this.get(this.buildUrl('/admin/posts', query), headers)
      .catch(async (error) => {
        const e = await Promise.resolve(error);
        return {
          error: getResponseError(e)
        };
      });
  }

  public findOne(id: string, headers = {}): Promise<Res<IPost>> {
    return this.get('/admin/posts/' + id, headers)
      .catch(async (error) => {
        const e = await Promise.resolve(error);
        return {
          error: getResponseError(e)
        };
      });
  }

  public delete(id: string) {
    return this.del('/admin/posts/' + id);
  }

  public signImageUploadUrl(): Promise<Res> {
    return this.post('/admin/posts/sign-upload-image-url')
      .catch(async (error) => {
        const e = await Promise.resolve(error);
        return {
          error: getResponseError(e)
        };
      });
  }

  public uploadFile(
    uploadUrl: string,
    file: any
  ) {
    return this.upload({
      url: uploadUrl, file, fieldName: 'file'
    });
  }

  getFileUploadedInfo(fileId: string) {
    return this.get(`/admin/posts/files/${fileId}/info`);
  }

  public update(id: string, data: Record<string, any>) {
    return this.put('/admin/posts/' + id, data);
  }
}

export const postService = new PostService();