import { getResponseError } from '@lib/utils';
import { APIRequest } from './api-request';
import { IPerformer, Res } from 'src/interfaces';

export class PerformerService extends APIRequest {
  public search(query = {}, headers = {}): Promise<Res<IPerformer[]>> {
    return this.get(this.buildUrl('/admin/performers', query), headers)
      .catch(async (error) => {
        const e = await Promise.resolve(error);
        return {
          error: getResponseError(e)
        };
      });
  }

  public findOne(id: string, headers = {}): Promise<Res<IPerformer>> {
    return this.get('/admin/performers/' + id, headers)
      .catch(async (error) => {
        const e = await Promise.resolve(error);
        return {
          error: getResponseError(e)
        };
      });
  }

  public delete(id: string) {
    return this.del('/admin/performers/' + id);
  }

  public signAvatarUploadUrl(): Promise<Res> {
    return this.post('/admin/performers/sign-upload-avatar-url')
      .catch(async (error) => {
        const e = await Promise.resolve(error);
        return {
          error: getResponseError(e)
        };
      });
  }

  public signCoverUploadUrl(): Promise<Res> {
    return this.post('/admin/performers/sign-upload-cover-url')
      .catch(async (error) => {
        const e = await Promise.resolve(error);
        return {
          error: getResponseError(e)
        };
      });
  }

  public uploadFile(
    uploadUrl: string,
    file: any
  ) {
    return this.upload({
      url: uploadUrl, file, fieldName: 'file'
    });
  }

  getFileUploadedInfo(fileId: string) {
    return this.get(`/admin/performers/files/${fileId}/info`);
  }

  public update(id: string, data: Record<string, any>) {
    return this.put('/admin/performers/' + id, data);
  }
}

export const performerService = new PerformerService();