import { getResponseError } from '@lib/utils';
import { APIRequest } from './api-request';
import { Res } from 'src/interfaces';

export class EmailTemplateService extends APIRequest {
  findAll(query = {}, headers = {}): Promise<Res<any[]>> {
    return this.get(this.buildUrl('/mailer/templates', query), headers).catch(async (error) => {
      const e = await Promise.resolve(error);
      return {
        error: getResponseError(e)
      };
    });
  }

  findById(id: string, headers = {}): Promise<Res<any>> {
    return this.get(`/mailer/templates/${id}`, headers).catch(async (error) => {
      const e = await Promise.resolve(error);
      return {
        error: getResponseError(e)
      };
    });
  }

  update(id: string, payload: Record<string, any>) {
    return this.put(`/mailer/templates/${id}`, payload);
  }
}

export const emailTemplateService = new EmailTemplateService();