import { getResponseError } from '@lib/utils';
import { APIRequest } from './api-request';
import { IChannel, Res } from 'src/interfaces';

export class ChannelService extends APIRequest {
  public search(query = {}, headers = {}): Promise<Res<IChannel[]>> {
    return this.get(this.buildUrl('/admin/channels', query), headers, { next: { tags: ['search', 'channel'] } })
      .catch(async (error) => {
        const e = await Promise.resolve(error);
        return {
          error: getResponseError(e)
        };
      });
  }

  public findOne(id: string, headers = {}): Promise<Res<IChannel>> {
    return this.get('/admin/channels/' + id, headers, { next: { tags: ['search', 'channel'] } })
      .catch(async (error) => {
        const e = await Promise.resolve(error);
        return {
          error: getResponseError(e)
        };
      });
  }

  public delete(id: string) {
    return this.del('/admin/channels/' + id);
  }

  public signImageUploadUrl(): Promise<Res> {
    return this.post('/admin/channels/sign-upload-image-url')
      .catch(async (error) => {
        const e = await Promise.resolve(error);
        return {
          error: getResponseError(e)
        };
      });
  }

  public uploadFile(
    uploadUrl: string,
    file: any
  ) {
    return this.upload({
      url: uploadUrl, file, fieldName: 'file'
    });
  }

  getFileUploadedInfo(fileId: string) {
    return this.get(`/admin/channels/files/${fileId}/info`);
  }

  public update(id: string, data: Record<string, any>) {
    return this.put('/admin/channels/' + id, data);
  }
}

export const channelService = new ChannelService();