import { getResponseError } from '@lib/utils';
import { APIRequest } from './api-request';
import { ICategory, Res } from 'src/interfaces';

export class CategoryService extends APIRequest {
  public search(query = {}, headers = {}): Promise<Res<ICategory[]>> {
    return this.get(this.buildUrl('/admin/categories', query), headers, { next: { tags: ['search', 'category'] } })
      .catch(async (error) => {
        const e = await Promise.resolve(error);
        return {
          error: getResponseError(e)
        };
      });
  }

  public findOne(id: string, headers = {}): Promise<Res<ICategory>> {
    return this.get('/admin/categories/' + id, headers, { next: { tags: ['search', 'category'] } })
      .catch(async (error) => {
        const e = await Promise.resolve(error);
        return {
          error: getResponseError(e)
        };
      });
  }

  public delete(id: string) {
    return this.del('/admin/categories/' + id);
  }

  public signImageUploadUrl(): Promise<Res> {
    return this.post('/admin/categories/sign-upload-poster-url')
      .catch(async (error) => {
        const e = await Promise.resolve(error);
        return {
          error: getResponseError(e)
        };
      });
  }

  public uploadFile(
    uploadUrl: string,
    file: any
  ) {
    return this.upload({
      url: uploadUrl, file, fieldName: 'file'
    });
  }

  getFileUploadedInfo(fileId: string) {
    return this.get(`/admin/categories/files/${fileId}/info`);
  }

  public update(id: string, data: Record<string, any>) {
    return this.put('/admin/categories/' + id, data);
  }
}

export const categoryService = new CategoryService();