import cookie from 'js-cookie';

import { APIRequest } from './api-request';
import { IUpdatePassword } from '../interfaces';

export class AuthService extends APIRequest {
  async login(payload: any): Promise<{ token: string }> {
    const { data } = await this.post('/auth/login', payload);
    cookie.set('token', data.token);
    return data;
  }

  getToken() {
    return cookie.get('token');
  }

  clearToken() {
    cookie.remove('token');
  }

  updatePassword(payload: IUpdatePassword) {
    return this.put('/auth/admin/change-password', payload);
  }

  forgotPassword(payload: any) {
    return this.post('/auth/forgot', payload);
  }
}

export const authService = new AuthService();
