import { getResponseError } from '@lib/utils';
import { APIRequest } from './api-request';
import { IAd, Res } from 'src/interfaces';

export class AdService extends APIRequest {
  public search(query = {}, headers = {}): Promise<Res<IAd[]>> {
    return this.get(this.buildUrl('/admin/ads', query), headers, { next: { tags: ['search', 'ad'] } })
      .catch(async (error) => {
        const e = await Promise.resolve(error);
        return {
          error: getResponseError(e)
        };
      });
  }

  public findOne(id: string, headers = {}): Promise<Res<IAd>> {
    return this.get('/admin/ads/' + id, headers, { next: { tags: ['search', 'ad'] } })
      .catch(async (error) => {
        const e = await Promise.resolve(error);
        return {
          error: getResponseError(e)
        };
      });
  }

  public delete(id: string) {
    return this.del('/admin/ads/' + id);
  }

  public signFileUploadUrl(data: Record<string, any>): Promise<Res> {
    return this.post('/admin/ads/sign-upload-file-url', data)
      .catch(async (error) => {
        const e = await Promise.resolve(error);
        return {
          error: getResponseError(e)
        };
      });
  }

  public uploadFile(
    uploadUrl: string,
    file: any
  ) {
    return this.upload({
      url: uploadUrl, file, fieldName: 'file'
    });
  }

  getFileUploadedInfo(fileId: string) {
    return this.get(`/admin/ads/files/${fileId}/info`);
  }

  public update(id: string, data: Record<string, any>) {
    return this.put('/admin/ads/' + id, data);
  }
}

export const adService = new AdService();