import { message } from 'antd';

export function getResponseError(data: any): string {
  if (!data) {
    return '';
  }
  if (typeof data === 'string') {
    return data;
  }
  // TODO - parse for language or others
  if (typeof data.message === 'string' || typeof data.msg === 'string')
    return data.message || data.msg;

  if (Array.isArray(data.message)) {
    const item = data.message[0];
    if (!item.constraints) {
      return item || data.error || 'An error occurred, please try again!';
    }
    return Object.values(item.constraints)[0] as string;
  }

  return 'An error occurred, please try again!';
}

export function redirect404(ctx: any = null) {
  if (typeof window !== 'undefined') {
    window.location.href = '/404';
    return {};
  }

  if (!ctx) return {};

  ctx.res.writeHead(302, { Location: '/404' });
  ctx.res.end();
  // getInitialProps should not return undefined
  return {};
}

export function redirectLogin(ctx: any = null) {
  if (typeof window !== 'undefined') {
    // authService.removeToken();
    window.location.href = '/auth/login';
    return;
  }

  if (ctx) {
    ctx.res.clearCookie('token');
    ctx.res.writeHead(302, { Location: '/auth/login' });
    ctx.res.end();
  }
}

export async function showError(e: any) {
  const error = await e;
  message.error(getResponseError(error));
}

export function getBaseApiEndpoint() {
  return process.env.API_ENDPOINT || process.env.NEXT_PUBLIC_API_ENDPOINT;
}
