import { message } from 'antd';
import { RcFile } from 'antd/es/upload';

export const checkImageBeforeUpload = (file: RcFile, sizeLimit = 20) => {
  const isJpgOrPng = file.type === 'image/jpeg' || file.type === 'image/png';
  if (!isJpgOrPng) {
    message.error('You can only upload JPG/PNG file!');
  }
  const isLt2M = file.size / 1024 / 1024 < sizeLimit;
  if (!isLt2M) {
    message.error(`Image must smaller than ${sizeLimit}MB!`);
  }
  return isJpgOrPng && isLt2M;
};

export const getBase64 = (img: RcFile, callback: (url: string) => void) => {
  const reader = new FileReader();
  reader.addEventListener('load', () => callback(reader.result as string));
  reader.readAsDataURL(img);
};
