export function isUrl(url: string): boolean {
  // eslint-disable-next-line no-useless-escape
  const regex = /(http|https):\/\/(\w+:{0,1}\w*)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%!\-\/]))?/;
  return regex.test(url);
}

export function capitalizeFirstLetter(str: string) {
  return str.charAt(0).toUpperCase() + str.slice(1);
}

export function getResponseError(data: any) {
  if (!data) {
    return '';
  }

  if (Array.isArray(data.message)) {
    const item = data.message[0];
    if (!item.constraints) {
      return item || data.error || 'Bad request!';
    }
    return Object.values(item.constraints)[0];
  }

  // TODO - parse for language or others
  return (
    typeof data.message === 'string'
    && (data.message === 'cyclic object value' ? 'Bad request!' : data.message)
  );
}

export function buildUrl(baseUrl: string, params?: { [key: string]: any }) {
  if (!params) {
    return baseUrl;
  }

  const queryString = Object.keys(params)
    .map((k) => {
      if (Array.isArray(params[k])) {
        return params[k]
          .map(
            (param: any) => `${encodeURIComponent(k)}=${encodeURIComponent(param)}`
          )
          .join('&');
      }
      return `${encodeURIComponent(k)}=${encodeURIComponent(params[k])}`;
    })
    .join('&');
  return `${baseUrl}?${queryString}`;
}