'use client';

import {
  HomeOutlined,
  VideoCameraOutlined,
  SettingOutlined,
  StarOutlined,
  TagOutlined,
  FileTextOutlined,
  ClearOutlined,
  MailOutlined,
  AppstoreAddOutlined
} from '@ant-design/icons';
import Link from 'next/link';
import { usePathname } from 'next/navigation';
import { useEffect, useState } from 'react';

import ScrollBar from './scroll-bar';
import SiderMenu from './side-menu';
import s from './sidenav.module.scss';
import { utilsService } from '@services/utils.service';
import { useConfig } from 'src/context/config.context';
import classNames from 'classnames';

interface P {
  color: string;
  collapsed: any;
}

const menuItems = [
  {
    key: 'dashboard',
    href: '/dashboard',
    icon: <HomeOutlined />,
    label: 'Dashboard',
    children: []
  },
  {
    key: 'video',
    icon: <VideoCameraOutlined />,
    label: 'Video',
    href: '#',
    children: [
      {
        key: 'video-list',
        label: 'Manage Existing Video',
        href: '/video'
      },
      {
        key: 'create-video',
        label: 'Add a new Video',
        href: '/video/create'
      },
      {
        key: 'video-categories-list',
        label: 'Manage Categories',
        href: '/category?group=video'
      }
    ]
  },
  {
    key: 'performer',
    icon: <StarOutlined />,
    label: 'Pornstars',
    href: '#',
    children: [
      {
        key: 'performer-list',
        label: 'Manage Pornstars',
        href: '/pornstar'
      },
      {
        key: 'create-performer',
        label: 'Add a new Pornstar',
        href: '/pornstar/create'
      }
    ]
  },
  {
    key: 'tag',
    icon: <TagOutlined />,
    label: 'Tags',
    href: '#',
    children: [
      {
        key: 'tag-list',
        label: 'Manage Tags',
        href: '/tag'
      },
      {
        key: 'create-tag',
        label: 'Add a new Tag',
        href: '/tag/create'
      }
    ]
  },
  {
    key: 'ad',
    icon: <AppstoreAddOutlined />,
    label: 'Advertising',
    href: '#',
    children: [
      {
        key: 'ads-list',
        label: 'Manage Ads',
        href: '/ad'
      },
      {
        key: 'create-ad',
        label: 'Add a new ad',
        href: '/ad/create'
      }
    ]
  },
  {
    key: 'post',
    icon: <FileTextOutlined />,
    label: 'Posts',
    href: '#',
    children: [
      {
        key: 'post-list',
        label: 'Manage Posts',
        href: '/post'
      },
      {
        key: 'create-post',
        label: 'Add a new post',
        href: '/post/create'
      },
      {
        key: 'post-categories-list',
        label: 'Manage Categories',
        href: '/category?group=post'
      }
    ]
  },
  {
    key: 'email',
    icon: <MailOutlined />,
    label: 'Email Template',
    href: '#',
    children: [
      {
        key: 'email-list',
        label: 'Manage Email Templates',
        href: '/email-template'
      }
    ]
  },
  {
    key: 'system',
    icon: <SettingOutlined />,
    label: 'System',
    href: '#',
    children: [
      {
        key: 'setting',
        label: 'Settings',
        href: '/setting'
      }
    ]
  },
  {
    key: 'clearCache',
    icon: <ClearOutlined />,
    label: 'Clear Cache',
    href: '#',
    onClick: async () => {
      await utilsService.clearCache();
    }
  }
];

function Sidenav({ color, collapsed }: P) {
  const [selectedKey, setSelectedKey] = useState('dashboard');
  const { logoUrl } = useConfig();
  const pathname = usePathname();

  const menus = menuItems.map((item: any) => {
    const isParent = item.children && item.children.length > 0;
    return {
      key: item.key,
      label: (
        <div key={item.key}>
          <Link href={item.href} onClick={item.onClick}>
            <span
              className="icon"
              style={
                {
                  // background: selectedKey === item.key ? color : "",
                }
              }
            >
              {item.icon}
            </span>
            <span className='label'>{item.label}</span>
          </Link>
        </div>
      ),
      ...(isParent && {
        children: item.children.map((child: any) => ({
          key: child.key,
          hidden: true,
          // label: <span className={s.label}>{child.label}</span>,
          label: (
            <span className={s.label}>
              <Link href={child.href}>{child.label}</Link>
            </span>
          )
        }))
      })
    };
  });

  useEffect(() => {
    const active = (menuItems as any)
      .reduce((acculator: any, menuItem: any) => {
        if (Array.isArray(menuItem.children) && menuItem.children.length > 0) {
          return [...acculator, menuItem, ...menuItem.children];
        }

        return [...acculator, menuItem];
      }, [])
      .find((i: any) => pathname === i.href);

    if (active) setSelectedKey(active.key);
  }, [pathname]);

  return (
    <div className={classNames(s.sider, { [s.collapsed]: collapsed })}>
      <div className={s.brand}>
        <div className={s.logo}>
          <Link href="/">
            <img alt="logo" src={logoUrl || '/logo.png'} />
          </Link>
        </div>
      </div>
      <div className={s['menu-container']}>
        <ScrollBar
          options={{
            // Disabled horizontal scrolling, https://github.com/utatti/perfect-scrollbar#options
            suppressScrollX: true
          }}
        >
          <SiderMenu
            menus={menus}
            theme={color}
            selectedKey={selectedKey}
            collapsed={collapsed}
          />
        </ScrollBar>
      </div>
    </div>
  );
}

export default Sidenav;
