import { Menu, MenuProps } from 'antd';
import { useState } from 'react';

type IProps = {
  theme?: string;
  menus?: any;
  collapsed?: boolean;
  selectedKey?: string;
};

export default function SiderMenu({
  theme, menus, collapsed, selectedKey
}: IProps) {
  const [openKeys, setOpenKeys] = useState([selectedKey as string]);
  const rootSubmenuKeys = menus.map((i: any) => i.key);

  const onOpenChange: MenuProps['onOpenChange'] = (keys) => {
    const latestOpenKey = keys.find((key) => openKeys.indexOf(key) === -1);
    if (latestOpenKey && rootSubmenuKeys.indexOf(latestOpenKey!) === -1) {
      setOpenKeys(keys);
    } else {
      setOpenKeys(latestOpenKey ? [latestOpenKey] : []);
    }
  };
  return (
    <Menu
      mode="inline"
      theme={theme as any}
      items={menus}
      inlineCollapsed={collapsed}
      // selectedKeys={[selectedKey as string]}
      openKeys={openKeys}
      onOpenChange={onOpenChange}
    />
  );
}
