'use client';

import {
  Layout, Affix
} from 'antd';
import { usePathname } from 'next/navigation';
import { useEffect, useState, useTransition } from 'react';

import Header from './header/header';
import Sidenav from './sidenav/sidenav';
import { useMainThemeLayout } from '../context/main-layout.context';
import Loader from './common/loader';
import { useProfile } from 'src/context/profile.context';
import dynamic from 'next/dynamic';

const Footer = dynamic(() => import('src/layout/footer'), { ssr: false })


const { Header: AntHeader, Content, Sider } = Layout;

function Main({ children }: any) {
  const { fetching } = useProfile();

  const {
    // placement,
    sidenavColor,
    sidenavType,
    fixed,
    onProgres,
    setOnProgress
  } = useMainThemeLayout();

  let pathname = usePathname();
  pathname = pathname.replace('/', '');

  const [collapsed, setCollapsed] = useState(true);
  const [, startTransition] = useTransition();

  const toggleCollapsed = () => {
    startTransition(() => {
      setCollapsed(!collapsed);
    });
  };

  useEffect(() =>  {
    setOnProgress(fetching);
  }, [setOnProgress, fetching]);


  return (
    <Layout
      className={`layout-dashboard ${
        pathname === 'profile' ? 'layout-profile' : ''
      } ${pathname === 'rtl' ? 'layout-dashboard-rtl' : ''}`}
    >
      <Loader fullScreen spinning={onProgres} />
      <Sider
        breakpoint="lg"
        // onCollapse={(collapsed, type) => {
        //   console.log(collapsed, type);
        // }}
        collapsed={collapsed}
        collapsible
        trigger={null}
        width={256}
        theme="light"
        className={`sider-primary ant-layout-sider-primary ${
          sidenavType === '#fff' ? 'active-route' : ''
        }`}
        style={{ background: sidenavType, padding: 0, margin: 0 }}
      >
        <Sidenav color={sidenavColor} collapsed={collapsed} />
      </Sider>
      <Layout className={!collapsed ? 'collapsed' : ''}>
        {fixed ? (
          <Affix>
            <AntHeader className={`${fixed ? 'ant-header-fixed' : ''}`}>
              {/* <Button type="primary" onClick={toggleCollapsed} style={{ marginBottom: 16 }}>
                {collapsed ? <MenuUnfoldOutlined /> : <MenuFoldOutlined />}
              </Button> */}
              <Header
                toggleCollapsed={toggleCollapsed}
                collapsed={collapsed}
                name={pathname}
                subName={pathname}
              />
            </AntHeader>
          </Affix>
        ) : (
          <AntHeader className={`${fixed ? 'ant-header-fixed' : ''}`}>
            {/* <Button type="primary" onClick={toggleCollapsed} style={{ marginBottom: 16 }}>
              {collapsed ? <MenuUnfoldOutlined /> : <MenuFoldOutlined />}
            </Button> */}
            <Header toggleCollapsed={toggleCollapsed} collapsed={collapsed} name={pathname}
                subName={pathname} />
          </AntHeader>
        )}
        <Content className="content-ant">{children}</Content>
        <Footer />
      </Layout>
    </Layout>
  );
}

export default Main;
