import {
  SettingOutlined,
  UserOutlined,
  MenuFoldOutlined,
  MenuUnfoldOutlined
} from '@ant-design/icons';
import {
  Row,
  Col,
  // Breadcrumb,
  Button,
  Drawer,
  Typography,
  Switch
} from 'antd';
import Link from 'next/link';
import { useState, useEffect } from 'react';

import { useMainThemeLayout } from 'src/context/main-layout.context';
import { useProfile } from 'src/context/profile.context';
import { authService } from 'src/services';

function Header({ toggleCollapsed, collapsed }: any) {
  const { Title, Text } = Typography;

  const [visible, setVisible] = useState(false);
  const { current } = useProfile();

  const {
    placement,
    sidenavType,
    fixed,
    // breadcrumbs,
    handleSidenavType,
    handleSidenavColor,
    handleFixedNavbar
  } = useMainThemeLayout();

  useEffect(() => window.scrollTo(0, 0));

  const showDrawer = () => setVisible(true);
  const hideDrawer = () => setVisible(false);

  const handleLogout = () => {
    hideDrawer();
    authService.clearToken();
    window.location.href = '/auth/login';
  };
  return (
    <Row gutter={[24, 0]}>
      <Col span={12} md={6}>
        <Button type="primary" onClick={toggleCollapsed}>
          {collapsed ? <MenuUnfoldOutlined /> : <MenuFoldOutlined />}
        </Button>
        {/* <Breadcrumb items={breadcrumbs} /> */}
      </Col>
      <Col span={12} md={18} className="header-control">
        <Button type="link" onClick={showDrawer}>
          <SettingOutlined />
        </Button>
        <Drawer
          className="settings-drawer"
          mask
          width={360}
          onClose={hideDrawer}
          placement={placement}
          open={visible}
        >
          <div>
            <div className="header-top">
              <Title level={4}>
                Configurator
                <Text className="subtitle">See our dashboard options.</Text>
              </Title>
            </div>

            <div className="sidebar-color" hidden>
              <Title level={5}>Sidebar Color</Title>
              <div className="theme-color mb-2">
                <>
                  <Button
                    type="primary"
                    onClick={() => handleSidenavColor('#1890ff')}
                  >
                    1
                  </Button>
                  <Button
                    style={{ background: '#52c41a' }}
                    onClick={() => handleSidenavColor('#52c41a')}
                  >
                    1
                  </Button>
                  <Button
                    type="primary"
                    danger
                    onClick={() => handleSidenavColor('#d9363e')}
                  >
                    1
                  </Button>
                  <Button
                    style={{ background: '#fadb14' }}
                    onClick={() => handleSidenavColor('#fadb14')}
                  >
                    1
                  </Button>

                  <Button
                    style={{ background: '#111' }}
                    onClick={() => handleSidenavColor('#111')}
                  >
                    1
                  </Button>
                </>
              </div>

              <div className="sidebarnav-color mb-2">
                <Title level={5}>Sidenav Type</Title>
                <Text>Choose between 2 different sidenav types.</Text>
                <>
                  <Button
                    onClick={() => {
                      handleSidenavType('transparent');
                    }}
                    type={sidenavType === 'transparent' ? 'primary' : 'default'}
                  >
                    TRANSPARENT
                  </Button>
                  <Button
                    onClick={() => {
                      handleSidenavType('#fff');
                    }}
                    type={sidenavType === '#fff' ? 'primary' : 'default'}
                  >
                    WHITE
                  </Button>
                </>
              </div>
              <div className="fixed-nav mb-2" hidden>
                <Title level={5}>Navbar Fixed </Title>
                <Switch
                  checked={fixed}
                  onChange={(e) => handleFixedNavbar(e)}
                />
              </div>
            </div>
            <div className="ant-docment">
              <>
                <Button size="large" onClick={handleLogout}>
                  LOG OUT
                </Button>
              </>
            </div>
          </div>
        </Drawer>
        <Link
          href={{
            pathname: '/user/update',
            query: { id: current?._id }
          }}
          className="btn-sign-in"
        >
          <UserOutlined />
          <span>{current?.username}</span>
        </Link>
      </Col>
    </Row>
  );
}

export default Header;
