import React from 'react';

import css from './loader.module.css';
import classNames from 'classnames';

interface IProps {
  spinning?: boolean;
  fullScreen?: boolean;
}

function Loader({ spinning = false, fullScreen = false }: IProps) {
  let className = css.loader;
  if (!spinning) className += ` ${css.hidden}`;
  if (fullScreen) className += ` ${css.fullScreen}`;
  return (
    <div
      className={classNames('loader', className)}
    >
      <div className={css.warpper}>
        <div className={css.inner} />
        <div className={css.text}>LOADING</div>
      </div>
    </div>
  );
}

export default Loader;
