import { HomeOutlined } from '@ant-design/icons';
import { Breadcrumb } from 'antd';
import Link from 'next/link';

interface IBreadcrum {
  title: string;
  href?: string;
}

interface Iprop {
  breadcrumbs: IBreadcrum[];
}

export default function BreadcrumbComponent({ breadcrumbs }: Iprop) {
  return (
    <div style={{ marginBottom: '16px' }}>
      <Breadcrumb>
        <Breadcrumb.Item href="/" key="home_ico">
          <HomeOutlined />
        </Breadcrumb.Item>
        {breadcrumbs
          && breadcrumbs.length > 0
          && breadcrumbs.map((b) => (
            <Breadcrumb.Item key={b.title + Math.floor(Math.random() * 1000)}>
              {b.href ? (
                <Link href={b.href}>
                  <p>{b.title}</p>
                </Link>
              ) : (
                b.title
              )}
            </Breadcrumb.Item>
          ))}
      </Breadcrumb>
    </div>
  );
}
