export interface IVideoFile {
  _id: string;
  url: string;
  thumbnailUrl: string;
}
export interface IVideo {
  _id: string;
  video: IVideoFile;
  teaser?: string;
  source: string;
  performerIds: string[];
  tags: string[];
  categoryIds: string[];
  status: string;
  convertStatus: string;
  thumbnails: string[];
  verified: boolean;
  embeddedCode?: string;
}

export interface IVideoUpload {
  title: string;
  slug: string;
  description: string;
  seoTitle: string;
  seoKeywords: string;
  seoDesc: string;
  performerIds: string[];
  tags: string[];
  categoryIds: string[];
  status: string;
  featured: boolean;
  price: number;
  fileId: string;
  verified: boolean;
}