import { UploadFileStatus } from 'antd/lib/upload/interface';

export interface IFileUpload {
  /**
   * url to get file upload URL
   */
  url: string;

  /**
   * file binary data
   */
  file: File;
  /**
   * type of file eg avatar, feed-photo...
   */
  type?: string;
  /**
   * field name for file upload. Default is `file`
   */
  fieldName?: string;

  /**
   * post data when calling get file upload url
   */
  body?: any;

  /**
   * callback function for upload
   */
  onProgress?: Function;

  /**
   * method for upload url. Default is `POST`
   */
  method?: string;

  fields?: Record<string, any>;

  header?: Record<string, any>;
}

export interface ISignUploadUrlPayload {
  url: string;
  data?: Record<string, any>;
  method?: string;
}


export interface IUploadResponse {
  percent: number;
  status: UploadFileStatus
}