'use client';

import {
  createContext, useContext, useState,
  ReactNode,
  useEffect,
  useMemo
} from 'react';

import { IProfile } from '../interfaces';
import { authService, profileService } from '../services';

export interface IProfileContext {
  current: IProfile;
  fetching: boolean;
}

const ProfileContext = createContext<IProfileContext>({
  current: null as any,
  fetching: true
});

export function ProfileContextProvider({ children }: { children: ReactNode }) {
  const [fetching, setFetching] = useState(true);
  const [current, setCurrent] = useState<IProfile>(null as any);
  const profileValue = useMemo(() => ({
    current,
    fetching
  }), [current, fetching]);

  const loadProfile = async () => {
    const token = authService.getToken();
    if (token) {
      try {
        setFetching(true);
        const { data } = await profileService.getMe(token);
        // TODO - check admin role on this route directly
        if (!data.roles || !data.roles.includes('admin')) {
          authService.clearToken();
          setFetching(false);
          window.location.href = '/auth/login';
          return;
        }
        setCurrent(data);
        setFetching(false);
      } catch {
        setFetching(false);
        authService.clearToken();
        // force login
        window.location.href = '/auth/login';
      }
    } else {
      setFetching(false);
    }
  };

  useEffect(() => {
    loadProfile();
  }, []);

  return (
    <ProfileContext.Provider value={profileValue}>
      {children}
    </ProfileContext.Provider>
  );
}

export const useProfile = () => useContext(ProfileContext);
