'use client';

import Link from 'next/link';
import {
  createContext, useContext, useState,
  ReactNode,
  useEffect,
  useMemo
} from 'react';

export interface IMainLayoutContext {
  placement: string | any;
  sidenavColor: string;
  sidenavType: string;
  fixed: boolean;
  breadcrumbs: any;
  onProgres: boolean;
  handleSidenavType: Function;
  handleSidenavColor: Function;
  handleFixedNavbar: Function;
  handlePlacement: Function;
  handleBreadcrumbs: Function;
  setOnProgress: Function;
}

const MainLayoutContext = createContext<IMainLayoutContext>({
  placement: 'right',
  sidenavColor: '#1890ff',
  sidenavType: '#fff',
  fixed: false,
  breadcrumbs: [],
  onProgres: true,
  handleSidenavType: () => {},
  handleSidenavColor: () => {},
  handleFixedNavbar: () => {},
  handlePlacement: () => {},
  handleBreadcrumbs: () => {},
  setOnProgress: () => {}
});

export interface IBreadcrumbOption {
  text: string;
  href?: string;
}

export function MainLayoutContextProvider({ children }: { children: ReactNode }) {
  const [placement, setPlacement] = useState('right');
  const [sidenavColor, setSidenavColor] = useState('#1890ff');
  const [sidenavType, setSidenavType] = useState('#fff');
  const [fixed, setFixed] = useState(false);
  const [breadcrumbs, setBreadcrumbs] = useState<any>([]);
  const [onProgres, setOnProgress] = useState(false);

  const setThemeValue = (key: string, val: any) => {
    const currentData = JSON.parse(localStorage.getItem('mainLayoutConfig') || '{}');
    currentData[key] = val;
    localStorage.setItem('mainLayoutConfig', JSON.stringify(currentData));
  };

  const handleSidenavType = (type: string) => {
    setSidenavType(type);
    setThemeValue('sidenavType', type);
  };
  const handleSidenavColor = (color: string) => {
    setSidenavColor(color);
    setThemeValue('sidenavColor', color);
  };
  const handleFixedNavbar = (type: boolean) => {
    setFixed(type);
    setThemeValue('fixed', type);
  };
  const handlePlacement = (type: string) => {
    setPlacement(type);
    setThemeValue('placement', type);
  };

  const handleBreadcrumbs = (breadcrumbsOptions: IBreadcrumbOption[], options: any = {}) => {
    const { hideDashboard } = options || {};
    if (hideDashboard) setBreadcrumbs(breadcrumbsOptions);
    const newBreadcrumbs = [
      {
        title: <Link href="/dashboard">Dashboard</Link>
      },
      ...breadcrumbsOptions.map((b) => {
        if (!b.href) return { title: b.text };
        return {
          title: <Link key={b.text} href={b.href}>{b.text}</Link>
        };
      })
    ];
    setBreadcrumbs(newBreadcrumbs);
  };

  const themeValue = useMemo(() => ({
    placement,
    sidenavColor,
    sidenavType,
    fixed,
    breadcrumbs,
    onProgres,
    handleSidenavType,
    handleSidenavColor,
    handleFixedNavbar,
    handlePlacement,
    handleBreadcrumbs,
    setOnProgress
  // eslint-disable-next-line react-hooks/exhaustive-deps
  }), [
    placement,
    sidenavColor,
    sidenavType,
    fixed,
    breadcrumbs,
    onProgres
  ]);


  useEffect(() => {
    const currentData = JSON.parse(localStorage.getItem('mainLayoutConfig') || '{}');
    if (currentData.placement) setPlacement(currentData.placement);
    if (currentData.sidenavColor) setSidenavColor(currentData.sidenavColor);
    if (currentData.sidenavType) setSidenavType(currentData.sidenavType);
    if (currentData.fixed) setFixed(currentData.fixed);
  }, []);

  return (
    <MainLayoutContext.Provider value={themeValue}>
      {children}
    </MainLayoutContext.Provider>
  );
}

export const useMainThemeLayout = () => useContext(MainLayoutContext);
