'use client';

import { PropsWithChildren, createContext, useContext } from 'react';

const defaultValues = {
  siteName: 'xStreamer',
  logoUrl: '',
  favicon: '',
  paygateSupport: [ 'ccbill' ],
  homeTitle: 'Home',
  homeMetaKeywords: '',
  homMetaDescription: '',
  headerScript: '',
  afterBodyScript: '',
  gaCode: ''
};

const ConfigContext = createContext(defaultValues);

type Settings = typeof defaultValues;

export function ConfigProvider({children, settings}: PropsWithChildren<{settings: Settings}>) {
  return <ConfigContext.Provider value={settings}>
    {children}
  </ConfigContext.Provider>
}

export const useConfig = () => useContext(ConfigContext);