'use client';
import { Col, Input, Row } from 'antd';
import { debounce } from 'lodash';
import { usePathname, useSearchParams, useRouter } from 'next/navigation';
import { useCallback } from 'react';
import s from './search-filter.module.scss';
import PerformerSelection from '@components/performer/performer-selection';
import TagSelection from '@components/tag/tag-selection';
import CategorySelection from '@components/category/category-selection';


export default function SearchFilterVideo() {
  const pathname = usePathname();
  const searchParams = useSearchParams();
  const router = useRouter();

  const createQueryString = useCallback(
    (name: string, value: string) => {
      const params = new URLSearchParams(searchParams)
      params.set(name, value || '')
      return params.toString()
    },
    [searchParams]
  )

  const onFilter = debounce((fieldname: string, value: any) => {
    const url = `${pathname}?${createQueryString(fieldname, value)}`;
    router.push(url)
  }, 200)

  return (
    <Row gutter={24} className={s['search-filter']}>
      <Col lg={6} md={6} xs={24}>
        <Input
          placeholder="Enter keyword"
          onChange={(e) =>
            onFilter('q', e.target.value)
          }
        />
      </Col>
      <Col lg={6} md={6} xs={24}>
        <PerformerSelection
          selectProps={{ defaultValue: null, style: { width: '100%' }, allowClear: true, autoClearSearchValue: true, placeholder: 'Enter pornstar name' }}
          onChange={(field: string, value: any) => onFilter(field, value)}
          fieldName='performerIds'
        />
      </Col>
      <Col lg={6} md={6} xs={24}>
        <CategorySelection
          selectProps={{ defaultValue: null, style: { width: '100%' }, allowClear: true, autoClearSearchValue: true, placeholder: 'Enter category name' }}
          onChange={(field: string, value: any) => onFilter(field, value)}
          fieldName='categoryIds'
          group="video"
        />
      </Col>
      <Col lg={6} md={6} xs={24}>
        <TagSelection
          selectProps={{ defaultValue: null, style: { width: '100%' }, allowClear: true, autoClearSearchValue: true, placeholder: 'Enter tag' }}
          onChange={(field: string, value: any) => onFilter(field, value)}
          fieldName='tags'
        />
      </Col>
    </Row>
  )
}