'use client';

import DebounceSelect from '@components/common/debounce-select-options';
import { tagService } from '@services/tag.service';
import { type SelectProps } from 'antd';
import { ITag, Res } from 'src/interfaces';

interface IProps {
  fieldName: string;
  onChange: Function;
  selectProps?: SelectProps;
}

export default function TagSelection({ onChange: onChangeHandler, fieldName, selectProps }: IProps) {

  async function getTags(q = '') {
    const { data: tagResp } = await tagService.search({
      q,
      limit: 100,
      status:'active'
    }) as Res;

    if (tagResp.data && tagResp.data.length) {
      return tagResp.data.map((t: ITag) => ({ label: t?.name || t.key, value: t._id }))
    }
    return [];
  }

  return (
    <DebounceSelect
      fetchOptions={(search: string = '') => getTags(search)}
      {...selectProps}
      onChange={(value) => onChangeHandler(fieldName, value)}
    />
  )
}