'use client';

import {
  Form,
  Button,

  Input,
  message,
  Select
} from 'antd';
import { FormInstance } from 'antd/lib/form';
import { useEffect, useRef } from 'react';
import {
  useFormStatus,
  useFormState
} from 'react-dom';
import { redirect } from 'next/navigation';
import { ActionState, ITag } from 'src/interfaces';

interface IProps {
  data?: ITag | undefined;
  onFinish: any
}

export function FormTag({ data = undefined, onFinish }: IProps) {
  const [state, formAction] = useFormState<ActionState, ITag>(onFinish, {});
  const formRef = useRef<FormInstance>(null);
  const { pending } = useFormStatus();

  useEffect(() => {
    if (state.success) {
      message.success('Updated Successfully');
      redirect('/tag');
    } else {
      state.message && message.error(state.message);
    }
  }, [state]);

  useEffect(() => {
    if (data) {
      formRef.current?.setFieldsValue(data);
    }
  }, [data]);

  return (
    <Form
      ref={formRef}
      onFinish={(values) => formAction({ ...data, ...values })}
      initialValues={{
        name: '',
        key: '',
        status: 'active'
      }}
      layout="vertical"
    >
      <Form.Item
        name="name"
        label="Name"
        rules={[
          { required: true, message: 'Name is required!' },
          {
            pattern: new RegExp(/^[a-zA-Z0-9\s]+$/),
            message: 'Name cannot contain special characters!'
          }
        ]}
      >
        <Input placeholder="Name" />
      </Form.Item>
      <Form.Item
        name="key"
        label="Key"
        rules={[
          { required: true, message: 'Required!' },
          {
            pattern: new RegExp(/^[a-z]+(-[a-z]+)*$/),
            message: 'Key is not valid'
          }
        ]}
      >
        <Input placeholder="Key" />
      </Form.Item>
      <Form.Item
        name="status"
        label="Status"
        rules={[{ required: true, message: 'Please select status!' }]}
      >
        <Select placeholder="Status">
          <Select.Option key="active" value="active">
            Active
          </Select.Option>
          <Select.Option key="inactive" value="inactive">
            Inactive
          </Select.Option>
        </Select>
      </Form.Item>
      <Form.Item>
        <Button
          type="primary"
          htmlType="submit"
          loading={pending}
          disabled={pending}
        >
          Submit
        </Button>
      </Form.Item>
    </Form>
  );
}
