'use client';

import Tabs from '@components/common/tabs';
import { useRouter } from 'next/navigation';

const tabs = [
  {
    key: 'general',
    label: 'General'
  },
  {
    key: 'seo',
    label: 'SEO'
  },
  {
    key: 'email',
    label: 'Emails'
  },
  {
    key: 'smtp',
    label: 'SMTP'
  },
  {
    key: 'customScript',
    label: 'Custom script'
  }
]

interface IProps {
  defaultTab?: string;
}
export default function SettingTab({ defaultTab }: IProps) {
  const router = useRouter();

  const handleChange = (key: string) => {
    router.push(`/setting/?group=${key}`);
  }

  return <Tabs data={tabs} onChange={(key: string) => handleChange(key)} defaultTab={defaultTab} />
}