'use client';

import { ISetting } from 'src/interfaces';
import SettingFormItem from './setting-form-item';
import { Button, Form, FormInstance, message } from 'antd';
import { useRef, useState } from 'react';
import { settingService } from '@services/setting.service';
import { useRouter } from 'next/navigation';
import { getResponseError } from '@lib/string';

interface IProps {
  settings: ISetting[];
  group?: string;
}
const layout = {
  labelCol: { span: 24 },
  wrapperCol: { span: 24 }
};

export default function SettingForm({
  settings = []
}: IProps) {
  const [updating, setUpdating] = useState(false);
  const dataChange = useRef<any>({});
  const formRef = useRef<any>();
  const router = useRouter();

  if (!settings.length) {
    return <p>No items</p>
  }

  const submit = async () => {
    try {
      if (Object.keys(dataChange.current).length > 0) {
        setUpdating(true);
        await Object.keys(dataChange.current).reduce(async (lp, key) => {
          await lp;
          await settingService.update(key, dataChange.current[key]);
          return Promise.resolve();
        }, Promise.resolve());
        dataChange.current = {};
        setUpdating(false);
        message.success('Updated successfully!');
      }
    } catch (error) {
      message.error(getResponseError(error));
    }finally{
      setUpdating(false);
      router.refresh();
    }
  }

  const initialValues = {} as any;
  settings.forEach((item: ISetting) => {
    initialValues[item.key] = item.value;
  });

  const onchange = (key: string, value: any) => {
    dataChange.current = { ...dataChange.current, [key]: value }
  }

  const onUploaded = (key: string, value: any) => {
    const formInstance = formRef.current as FormInstance;
    formInstance.setFieldsValue({
      [key]: value
    });
    dataChange.current = { ...dataChange.current, [key]: value }
  }

  return (
    <Form
      {...layout}
      name="setting-frm"
      initialValues={initialValues}
      onFinish={submit}
      ref={formRef}
    >
      {settings.map(setting => <SettingFormItem setting={setting} key={setting.key} onChange={onchange} onUploaded={onUploaded} />)}
      {/* {group === 'smtp' && <Form.Item
        className="text-center"
        help="A test email will be sent to your admin email address. Make sure sender email and admin email is valid."
      >
        <div>
          <Button disabled={updating} loading={updating} onClick={() => { }} type="link">Test SMTP</Button>
        </div>
      </Form.Item>} */}
      <Form.Item className="text-center">
        <Button type="primary" htmlType="submit" disabled={updating} loading={updating}>
          Submit
        </Button>
      </Form.Item>
    </Form>
  )
}