import FileUpload from '@components/file/file-upload';
import ImageUpload from '@components/file/image-upload';
import { settingService } from '@services/setting.service';
import { ISetting } from 'src/interfaces';

interface IProps {
  setting: ISetting;
  onUploaded: Function;
}

export default function SettingFormUpload({ setting, onUploaded }: IProps) {
  if (!setting.meta || !setting.meta.upload) {
    return null;
  }

  const onFileSelected = async (file: File) => {
    const { data } = await settingService.getFileUploadUrl();
    if (data.uploadUrl) {
      const resp = await settingService.uploadSettingFile(data.uploadUrl, file) as any;
      if (resp.status) {
        const { data: fileInfo } = await settingService.getFileUploadedInfo(data.fileId);
        onUploaded(setting.key, fileInfo.url);
      }
    }
  }

  if (setting.meta.file) {
    return (
      <div style={{ padding: '10px 0' }} key={`upload${setting._id}`}>
        <FileUpload />
      </div>
    );
  }

  return (
    <div style={{ padding: '10px 0' }} key={`upload${setting._id}`}>
      <ImageUpload
        image={setting.value}
        onFileSelected={onFileSelected}
      />
    </div>
  );
}