/* eslint-disable @typescript-eslint/no-unused-vars */
/* eslint-disable react/jsx-props-no-spreading */

'use client';

import {
  Button, Form, Input, message
} from 'antd';
import { useState } from 'react';

import s from './profile-form.module.scss';
import Page from '../layout/page';

import { IProfile } from 'src/interfaces';
import { authService } from 'src/services';

const layout = {
  labelCol: { span: 24 },
  wrapperCol: { span: 24 }
};

interface IProps {
  profile: IProfile;
}

export default function UpdatePasswordForm({ profile }: IProps) {
  const [updating, setUpdating] = useState(false);
  const onFinish = async (item: any) => {
    try {
      setUpdating(true);
      await authService.updatePassword({
        profileId: profile._id,
        password: item.password
      });
      setUpdating(false);
      message.success('Update password successfully !!!');
    } catch (error) {
      setUpdating(false);
      message.error('Update password failed');
    }
  };
  return (
    <Page className={s['table-responsive']}>
      <Form name="nest-messages" onFinish={onFinish} {...layout}>
        <Form.Item
          name="password"
          label="Password"
          rules={[
            { required: true, message: 'Please input your password!' },
            { min: 8, message: 'Enter password of at least 8 characters' }
          ]}
        >
          <Input.Password placeholder="Enter password of at least 8 characters" />
        </Form.Item>
        <Form.Item
          name="oldPassword"
          label="Confirm Password"
          rules={[
            { required: true, message: 'Please input your confirm password!' },
            { min: 8, message: 'Enter password of at least 8 characters' },
            ({ getFieldValue }) => ({
              validator(rule, value) {
                if (!value || getFieldValue('password') === value) {
                  return Promise.resolve();
                }
                // eslint-disable-next-line prefer-promise-reject-errors
                return Promise.reject('Passwords do not match!');
              }
            })
          ]}
        >
          <Input.Password placeholder="Enter confirm password of at least 8 characters" />
        </Form.Item>

        <Form.Item className={s['text-center']}>
          <Button type="primary" htmlType="submit" loading={updating}>
            Update
          </Button>
        </Form.Item>
      </Form>
    </Page>
  );
}
