'use client';

import DebounceSelect from '@components/common/debounce-select-options';
import { profileService } from '@services/profile.service';
import { type SelectProps } from 'antd';
import { IProfile, Res } from 'src/interfaces';

interface IProps {
  fieldName: string;
  onChange: Function;
  selectProps?: SelectProps;
}

export default function ProfileSelection({ onChange: onChangeHandler, fieldName, selectProps }: IProps) {

  async function getProfile(q = '') {
    const { data: profileResp } = await profileService.search({
      q,
      limit: 100
    }) as Res;

    let result = [{label: 'All', value: ''}];

    if (profileResp.data && profileResp.data.length) {
      result = [...result, ...profileResp.data.map((p: IProfile) => ({ label: p?.username, value: p._id }))]
    }
    return result;
  }

  return (
    <DebounceSelect
      fetchOptions={(search: string = '') => getProfile(search)}
      {...selectProps}
      onChange={(value) => onChangeHandler(fieldName, value)}
    />
  )
}