/* eslint-disable import/no-unresolved */
/* eslint-disable @typescript-eslint/no-unused-vars */

'use client';

import {
  Col, Form, Row, Image, message
} from 'antd';
import { useEffect, useState } from 'react';

import { IProfile } from 'src/interfaces';
import { profileService } from 'src/services';

interface IProps {
  profile: IProfile;
}

const layout = {
  labelCol: { span: 8 },
  wrapperCol: { span: 24 }
};

export default function ProfileDocument({ profile }: IProps) {
  const [idVerificationUrl, setIdVerificationUrl] = useState<any>();

  const dataProfileDocs = async () => {
    try {
      const data: any = await profileService.getProfileDocs({ profileId: profile._id });
      setIdVerificationUrl(data);
    } catch (error) {
      const e = Promise.resolve(error) as any;
      message.error(e);
    }
  };

  useEffect(() => {
    dataProfileDocs();
  }, []);

  return (
    // eslint-disable-next-line react/jsx-props-no-spreading
    <Form {...layout} name="form-user">
      <Row>
        <Col xs={24} md={8}>
          <Form.Item label="Front Side ID photo">
            <div style={{ display: 'flex', justifyContent: 'space-around' }}>
              {idVerificationUrl?.data[0] ? <Image src={idVerificationUrl?.data[0].fileInfo.url} width="150px" alt='' /> : <img width="150px" src="/id-document.png" alt="holding-id" />}
            </div>
          </Form.Item>
        </Col>
        <Col xs={24} md={8}>
          <Form.Item label="Back Side ID photo">
            <div style={{ display: 'flex', justifyContent: 'space-around' }}>
              {idVerificationUrl?.data[1] ? <Image src={idVerificationUrl?.data[1].fileInfo.url} width="150px" alt='' /> : <img width="150px" src="/id-img.jpeg" alt="id-pt" />}
            </div>
          </Form.Item>
        </Col>
        <Col xs={24} md={8}>
          <Form.Item label="Holding ID photo">
            <div style={{ display: 'flex', justifyContent: 'space-around' }}>
              {idVerificationUrl?.data[2] ? <Image src={idVerificationUrl?.data[2].fileInfo.url} width="150px" alt='' /> : <img width="150px" src="/id-img.jpeg" alt="id-pt" />}
            </div>
          </Form.Item>
        </Col>
      </Row>
    </Form>
  );
}
